﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.SharePoint;

class Program
{
   static void Main(string[] args)
   {
      using (SPSite site = new SPSite("http://contoso.de"))
      {
         using (SPWeb web = site.OpenWeb())
         {
            // Hole die Quellliste
            SPList sourceList = web.Lists.TryGetList("Kunden");

            // Hole die Collection der verbundenen Felder
            SPRelatedFieldCollection relatedFields =
               sourceList.GetRelatedFields();
            
            foreach (SPRelatedField field in relatedFields)
            {
               // Hole das Web und die Liste der verbundenen Spalte 
               SPWeb relatedWeb = site.AllWebs[field.WebId];
               SPList relatedList = relatedWeb.Lists[field.ListId];

               // Hole die Lookup-Spalte aus der verbundenen Liste
               SPFieldLookup relatedField = 
                  relatedList.Fields[field.FieldId] as SPFieldLookup;
               
               Console.WriteLine("Quellliste: {0} ({1})\n",
                  sourceList.Title, sourceList.ParentWeb.Url);
               
               Console.WriteLine("> Verbundene Liste: {0} ({1})",
                  relatedList.Title, relatedWeb.Url);

               Console.WriteLine("> Primäre Spalte: {0} ({1})",
                  relatedField.StaticName, relatedField.Title);

               Console.WriteLine("> Löschverhalten: {0}", 
                  relatedField.RelationshipDeleteBehavior);

               // Hole die Liste der sekundären Spalten
               List<string> depends = 
                  relatedField.GetDependentLookupInternalNames();

               Console.WriteLine("> Sekundäre Spalten:");

               // Iteriere die Liste der Spalte und hole das passende Lookup-Feld
               for (int i = 0; i < depends.Count; i++)
               {
                  SPFieldLookup secundaryField = 
                     relatedList.Fields.GetFieldByInternalName(
                     depends[i]) as SPFieldLookup;

                  Console.WriteLine("  > {0} ({1})",
                     secundaryField.Title, 
                     secundaryField.InternalName);                                    
               }
               Console.WriteLine();

               relatedWeb.Dispose();
            }
         }
      }
   }
}
